/* Contain the entire script within a function because REPORTER onrefCHEST_BELT_LOADly has a single JavaScript realm
 * for the entire session. */
head_and_neck_score();

function getModifierValue(status, key) {
    const value = get_variable_value(status, key, "string");

    if (value == "Yes") {
        return -5;
    }

    if (value == "No") return 0;
    return parseFloat(value); // fallback if it's actually a number in string form
}
/**
 * Performs the head and neck score calculation for the specified models
 */

function head_and_neck_score() {
    let templ = Template.GetCurrent();
    // let models = get_model_list();
    let models = ["M1", "T1"];
    let body_region_label = `head`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head score and modifiers */

            /* Shared */

            let head_hic_score = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_HIC_SCORE`,
                "float",
                templ
            );
            let head_hic_score_banded = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE_ENCAP_BANDED`, "float");
            let head_three_ms_exc_score = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                "float",
                templ
            );
            let head_three_ms_exc_score_banded = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE_ENCAP_BANDED`,
                "float"
            );

            let head_hic_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_HIC_CAPPING_LIMIT`);
            let head_tms_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_CAPPING_LIMIT`
            );

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let head_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let head_capping_limit = "";

            /* If we have all the required variables, calculate the final scores */
            if (true) {
                /* Head score is sum of score with modifiers.
                 * For the driver, steering wheel airbag must be present or score remains zero. */

                head_score = Math.min(head_hic_score_banded, head_three_ms_exc_score_banded);

                LogPrint(`${m} ${occ} head score = ${head_score}`);

                /* Overall score is minimum of head and neck scores */

                /* Overall scores */
                let head_score_var = new_variable_and_new_euroNCAP_banded_score(
                    templ,
                    `${m}_${occ}_HEAD_FINAL_SCORE`,
                    "Final head score",
                    head_score.toString(),
                    "String",
                    false,
                    true
                );
                let head_hic_score_var = new_variable_and_new_euroNCAP_banded_score(
                    templ,
                    `${m}_${occ}_HEAD_HIC_SCORE`,
                    " head HIC score",
                    head_hic_score.toString(),
                    "String",
                    false,
                    true
                );
                let head_three_ms_exc_score_var = new_variable_and_new_euroNCAP_banded_score(
                    templ,
                    `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                    " head three ms exe score",
                    head_three_ms_exc_score.toString(),
                    "String",
                    false,
                    true
                );

                /* Capping limits */
                let head_capping_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_HEAD_CAPPING_LIMIT`,
                    "Head capping limit (*asterisk if limit exceeded; empty string otherwise)",
                    head_capping_limit,
                    "String",
                    false,
                    true
                );
            }

            // ------------------------------
            // Head Excursion Scoring Section
            // ------------------------------

            const excursionScores = {
                GREEN: { wc: 2.0, woc: 2.0 },
                YELLOW: { wc: 2.0, woc: 1.5 },
                ORANGE: { wc: 1.5, woc: 0.5 },
                RED: { wc: 0.5, woc: 0.0 }
            };

            let head_excursion_color = get_variable_value(
                true,
                `${m}_${occ}_DRIVER_HEAD_EXCURSION_RATING`,
                "string",
                false
            );

            let { wc: head_excursion_wc, woc: head_excursion_woc } = excursionScores[head_excursion_color] || {
                wc: 0,
                woc: 0
            };

            LogPrint(`${m} ${occ} head excursion color = ${head_excursion_color}`);
            LogPrint(`${m} ${occ} head excursion scores: WC=${head_excursion_wc}, WOC=${head_excursion_woc}`);

            let head_excursion_wc_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_EXCURSION_SCORE_WC`,
                "Head excursion score (with countermeasure)",
                head_excursion_wc.toString(),
                "String",
                false,
                true
            );

            let head_excursion_woc_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_EXCURSION_SCORE_WOC`,
                "Head excursion score (without countermeasure)",
                head_excursion_woc.toString(),
                "String",
                false,
                true
            );
        }
    }
}
